﻿
-- CREATE THE SEQUENCE TABLE
IF NOT EXISTS (SELECT * FROM sys.tables WHERE [type]='U' AND [name]='Sequence') 
BEGIN
	CREATE TABLE [Sequence] (
		[Name] [varchar](100) NOT NULL,
		[Value] [bigint] NOT NULL,
	 CONSTRAINT [PK_Sequence] PRIMARY KEY CLUSTERED
	(     [Name] ASC )
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] 
	
	ALTER TABLE [dbo].[Sequence] ADD  CONSTRAINT [DF_Sequence_Value]  DEFAULT ((0)) FOR [Value]
	
END
GO

-- Insert the first sequence based on the Max ResRespondent
INSERT INTO Sequence 
(Name,Value)
SELECT 'Respondent',ISNULL(MAX(ResRespondent),0) FROM Respondent
GO
